define([
    'underscore',
    'backbone',
    'App',
    'User',
    'modules/page/popup/warning-popup-view',
    'text!modules/notifications/notification-cancellation-popup-view.html',
],
function(_, Backbone, app, User, WarningPopupView, deleteModalTemplate) {
    'use strict';

    return WarningPopupView.extend({
        id: 'notification-cancellation',
        template: _.template(deleteModalTemplate),
        continue: function(e) {
            var url = app.resources.get('notifications-instance').formatHref({
                'assigning-authority': User.get('idType'),
                'unique-id': User.get('id'),
                'notification-id': this.model.get('_id'),
            });

            this.model.destroy({
                url: url,
                wait: true,
                success: function() {
                    Backbone.history.navigate('notifications', {trigger: true});
                },
            });

        },
        closePopup: function(e) {
            $('#' + this.id).popup('close');

            // only focus on element if "Continue" button not clicked,
            // because page is going to redraw on continue()
            if ($(e.currentTarget).is(':not(.warning-continue-btn)')) {
                this.focusOnElAfterClose();
            }
        },
    });
});
